/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui;

import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class SliderWidget
extends BaseWidget {
    private static final class_2960 SLIDER_TEXTURE = class_2960.method_60655((String)"movingelevators", (String)"textures/gui/slider.png");
    private final int min;
    private final int max;
    private final int range;
    private int value;
    private int lastValue;
    private final Function<Integer, class_2561> text;
    private final Consumer<Integer> onChange;
    private boolean dragging = false;
    public boolean active = true;

    public SliderWidget(int x, int y, int width, int min, int max, int startValue, Function<Integer, class_2561> text, Consumer<Integer> onChange) {
        super(x, y, width, 11);
        if (max < min) {
            throw new IllegalArgumentException("Maximum must be greater than the minimum!");
        }
        if (startValue < min || startValue > max) {
            throw new IllegalArgumentException("Start value must be between the minimum and maximum!");
        }
        this.min = min;
        this.max = max;
        this.range = max - min;
        this.value = this.lastValue = startValue;
        this.text = text;
        this.onChange = onChange;
    }

    public class_2561 getNarrationMessage() {
        return this.text.apply(this.value);
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        if (this.dragging) {
            this.value = Math.min(this.max, Math.max(this.min, Math.round((float)(mouseX - this.x) / (float)this.width * (float)this.range) + this.min));
        }
        ScreenUtils.bindTexture((class_2960)SLIDER_TEXTURE);
        ScreenUtils.drawTexture((class_4587)context.poseStack(), (float)this.x, (float)this.y, (float)1.0f, (float)this.height, (float)0.0f, (float)0.0f, (float)0.055555556f, (float)1.0f);
        ScreenUtils.drawTexture((class_4587)context.poseStack(), (float)(this.x + 1), (float)this.y, (float)(this.width - 2), (float)this.height, (float)0.055555556f, (float)0.0f, (float)0.055555556f, (float)1.0f);
        ScreenUtils.drawTexture((class_4587)context.poseStack(), (float)(this.x + this.width - 1), (float)this.y, (float)1.0f, (float)this.height, (float)0.11111111f, (float)0.0f, (float)0.055555556f, (float)1.0f);
        float percentage = (float)(this.value - this.min) / (float)this.range;
        ScreenUtils.drawTexture((class_4587)context.poseStack(), (float)((float)this.x + percentage * (float)(this.width - 5)), (float)this.y, (float)5.0f, (float)this.height, (float)(this.active ? (this.isFocused() || this.dragging ? 0.44444445f : 0.16666667f) : 0.7222222f), (float)0.0f, (float)0.2777778f, (float)1.0f);
        class_2561 text = this.text.apply(this.value);
        if (text != null) {
            ScreenUtils.drawCenteredStringWithShadow((class_4587)context.poseStack(), (class_2561)text, (float)((float)this.x + (float)this.width / 2.0f), (float)(this.y + 2), (int)0xE0E0E0);
        }
    }

    public void update() {
        super.update();
        if (this.value != this.lastValue) {
            this.onChange.accept(this.value);
            this.lastValue = this.value;
        }
    }

    public boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (!hasBeenHandled && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
            this.dragging = true;
            return true;
        }
        return super.mousePressed(mouseX, mouseY, button, hasBeenHandled);
    }

    public boolean mouseReleased(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (this.dragging) {
            this.dragging = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button, hasBeenHandled);
    }

    public boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled) {
        if (!hasBeenHandled && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
            if (scrollAmount > 0.0 && this.value < this.max) {
                ++this.value;
            } else if (scrollAmount < 0.0 && this.value > this.min) {
                --this.value;
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled);
    }
}

